<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\PeopleService;

class Source extends \Google\Site_Kit_Dependencies\Google\Model
{
    public $etag;
    public $id;
    protected $profileMetadataType = \Google\Site_Kit_Dependencies\Google\Service\PeopleService\ProfileMetadata::class;
    protected $profileMetadataDataType = '';
    public $type;
    public $updateTime;
    public function setEtag($etag)
    {
        $this->etag = $etag;
    }
    public function getEtag()
    {
        return $this->etag;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    /**
     * @param ProfileMetadata
     */
    public function setProfileMetadata(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\ProfileMetadata $profileMetadata)
    {
        $this->profileMetadata = $profileMetadata;
    }
    /**
     * @return ProfileMetadata
     */
    public function getProfileMetadata()
    {
        return $this->profileMetadata;
    }
    public function setType($type)
    {
        $this->type = $type;
    }
    public function getType()
    {
        return $this->type;
    }
    public function setUpdateTime($updateTime)
    {
        $this->updateTime = $updateTime;
    }
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\Source::class, 'Google\\Site_Kit_Dependencies\\Google_Service_PeopleService_Source');
